#!/bin/bash

set -e

targetVersion=$1
ccmbTargetVersion=$2

if [ -z "$targetVersion" ]; then
	echo "You need to provide version numbers as a parameters. Example usage: '"${BASH_SOURCE[0]}" 1.0.4' 3.5.6-3"
	exit 1
fi

if [ -z "$ccmbTargetVersion" ]; then
	echo "You need to provide version numbers as a parameters. Example usage: '"${BASH_SOURCE[0]}" 1.0.4' 3.5.6-3"
	exit 1
fi

apt-get update -o Dir::Etc::sourcelist=/etc/apt/sources.list.d/trend-online-production.list -o Dir::Etc::sourceparts='-' -o APT::Get::List-Cleanup='0'

apt-cache policy -o Dir::Etc::sourcelist=/etc/apt/sources.list.d/trend-online-production.list -o Dir::Etc::sourceparts='-' -o APT::Get::List-Cleanup='0' lantek4

apt-get install -o Dir::Etc::sourcelist=/etc/apt/sources.list.d/trend-online-production.list -o Dir::Etc::sourceparts='-' -o APT::Get::List-Cleanup='0' lantek4=$targetVersion lantek4-ccmb=$ccmbTargetVersion
